import { Control } from "../../api/gui/Control.js"

export class CodeControl extends Control {
  static plan = {
    tag: "ui-code",
    tabIndex: -1,
    on: {
      focus: (e, target) => {
        if (target === document.activeElement) {
          target.#inputEl.focus()
        }
      },
    },
  }

  /** @type {HTMLInputElement} */
  #inputEl

  valueChanged() {
    if (!this.#inputEl) return
    this.#inputEl.value = this.value
  }

  render() {
    return [
      {
        tag: "textarea.clear",
        role: "none",
        value: this.value,
        on: {
          "input || change": (e, target) => {
            this.setValue(target.value, { fromInput: true })
          },
        },
        created: (el) => {
          this.#inputEl = el
        },
      },
    ]
  }
}

export const code = Control.define(CodeControl)
