/* eslint-disable no-new-func */
export function compileBytebeat(formula) {
  // Optimize code like eval(unescape(escape`XXXX`.replace(/u(..)/g,"$1%")))
  formula = formula
    .trim()
    .replace(
      /^eval\(unescape\(escape(?:`|\('|\("|\(`)(.*?)(?:`|'\)|"\)|`\)).replace\(\/u\(\.{2}\)\/g,["'`]\$1%["'`]\){3}$/,
      (_, m1) => unescape(escape(m1).replaceAll(/u(..)/g, "$1%")),
    )

  const keys = Object.getOwnPropertyNames(Math)
  const values = keys.map((key) => Math[key])
  keys.push("int", "window")
  values.push(Math.floor, globalThis)

  const source = `return 0,\n${formula};`

  try {
    const generator = new Function(...keys, "t", source).bind(
      globalThis,
      ...values,
    )
    generator(0)
    return generator
  } catch (err) {
    return [err, source]
  }
}
