import { threadify } from "../../../api/threadify.js"
import { AudioProcessorNode } from "../AudioProcessorNode.js"

/* MARK: Node
------------- */

const thread = await threadify(
  import.meta.resolve("./MP3Compression/lameEncode.w.js"),
  {
    calls: {
      setup: {
        getTransfer([message, transfer]) {
          return {
            args: [message],
            transfer,
          }
        },
      },
    },
  },
)

export class MP3CompressionNode extends AudioProcessorNode {
  static module = import.meta.resolve(
    "./MP3Compression/MP3CompressionProcessor.js",
  )

  /** @type {AudioParam} */ bits
  /** @type {AudioParam} */ resolution

  constructor(context, parameterData) {
    super(context, "mp3-compression", {
      parameterData,
    })
    this.setParameters()

    const channel = new MessageChannel()

    this.port.postMessage({ workerPort: channel.port1 }, [channel.port1])

    thread.setup(
      {
        sampleRate: context.sampleRate,
        kbps: 16,
        port: channel.port2,
      },
      [channel.port2],
    )
  }
}
