import { AudioProcessor } from "../../AudioProcessorNode.js"

/**
 * An AudioWorkletProcessor that compresses audio to MP3 in real-time,
 * creating a distortion-like effect.
 */
class MP3CompressionProcessor extends AudioProcessor {
  constructor(options) {
    super(options)

    this.decodedData = []

    this.port.onmessage = ({ data }) => {
      if (data.workerPort) {
        this.workerPort = data.workerPort
      }
    }
  }

  /**
   * @param {Float32Array[][]} inputs
   * @param {Float32Array[][]} outputs
   */
  process([input], [output]) {
    if (input.length === 0) return this.running

    // Send the audio data to the worker for encoding/decoding
    this.workerPort.postMessage(input)

    // // Output the decoded data (or original if no decoded data yet)
    // if (this.decodedData.length > 0) {
    //   const decodedFrame = this.decodedData.shift() // Get the oldest decoded frame

    //   if (decodedFrame?.[0].length === output[0].length) {
    //     output[0].set(decodedFrame[0])
    //     output[1].set(decodedFrame[1])
    //   } else {
    //     console.warn(
    //       "Decoded frame size mismatch or no decoded data available.",
    //     )
    //     output[0].set(input[0])
    //     output[1].set(input[1])
    //   }
    // } else {
    //   output[0].set(input[0])
    //   output[1].set(input[1])
    // }

    return this.running
  }
}

AudioProcessor.define("mp3-compression", MP3CompressionProcessor)
